% This function computes the average spectrum for the whole
% subjects of the tumor heterogeneity

function Avg_Spectrum_PerPatient = Average_Spectrum(image_data,Mask,goodlist,region_overview)

n_patients = length(unique(region_overview(:))) - 1; % (-1) to exclude th background from counting
SS = size(image_data);
Avg_Spectrum_PerPatient = zeros(n_patients,SS(2));
% Avg_Spectrum = zeros(SS(2),1);

for ID =1:n_patients
    Filtered_Mask = zeros(SS(1),1);
    indxx = find((goodlist>0)&(region_overview(:)==ID));
    Filtered_Mask(indxx) = Mask(indxx);
    index_Filtered = find(Filtered_Mask==1);
    MS_P = image_data(index_Filtered,:);
    for i=1:SS(2)
        Avg(i) = mean(MS_P(:,i));
    end
    Avg_Spectrum_PerPatient(ID,:) = Avg;
    clear Avg MS_P
end





% % % Average Spectrum
% % index_Filtered = find(Mask==1);
% % for i =1:SS(2)
% %     Avg_Spectrum(i) = mean(image_data(index_Filtered,i));
% % end